.section .wakeupo,ax
b sleep_recovery

.globl cfg_MMU, sleep_recovery, sleep_recovery_RAM
.extern __start          # Primary program entry point defined in __start.s

.section .wakeupc,ax
    
#************************************************************************/
# FUNCTION     : sleep_recovery                                         */
# PURPOSE      : This function is intended to be used when recovering	*/
#	       : from sleep to a FLASH ISR so that an initial TLB3 entry*/
#	       : is made to maintain accesses to RAM before configuring	*/
#	       : the MMU as traditionally done.  Coming out of sleep to	*/
#	       : RAM only an initial 4KB aligned area is set up in TLB0 */
# INPUT NOTES  : None							*/
# RETURN NOTES : None                                                   */
# WARNING      : Registers used: R5			                */
#************************************************************************/

sleep_recovery:
# Enable SPE
 mfmsr r6
 oris  r6, r6, 0x0200
 mtmsr r6

# Clear Timebase
 li r3, 0
 mtspr 284, r3
 mtspr 285, r3

# Enable Timebase
 li r3, 0x4000
 mtspr HID0, r3

 bl cfg_MMU
 bl disable_SWT 

 lis	r4,0xFFFE
 ori	r4,r4,0xC058	#-- CRP.RECPRTR address
 lwz	r1,0x0(r4)	#-- Restore stack pointer from CRP
 lmw	r25,0x78(r1)	#-- Load SPR values back into GPRs
 mtSRR1	r25
 mtSRR0	r26
 mtLR	r27
 mtmsr	r28
 mtCR	r29
 mtXER	r30
 mtCTR	r31		#-- Load SPRs with GPR values
 lmw	r2, 0(r1)	#-- Restore GPRs from stack
 addi	r1,r1,0x94	#-- Deallocate space on stack
 blr			#-- Branch back to calling function

#end of sleep_recovery

#*****************************************************************************/
# FUNCTION     : cfg_MMU                                                     */
# PURPOSE      : This function modifies the MMU TLB (translation lookaside   */
#                buffer) table by writing to the appropriate MAS registers.  */                                        */
# RETURN NOTES : None                                                        */
# WARNING      : Registers used: R3,R5. Commands "msync" and "isync" are not */
#                required around the tlbwe since we are at configuration and */
#                other background operations cannot be active.               */
#*****************************************************************************/
cfg_MMU:

#***************************************************/
#     setup MMU                                    */
#***************************************************/

#TLB0 =  Flash - 1MB
   lis r3, 0x1000
   mtmas0 r3
   lis  r3, 0xC000
   ori r3, r3, 0x0500
   mtmas1	r3
   lis  r3, 0x0000
   ori r3, r3, 0x0000
   mtmas2	 r3
   lis  r3, 0x0000
   ori  r3, r3, 0x003F
   mtmas3	 r3
   tlbwe

#TLB1 =  Flash - 1MB
   lis r3, 0x1001
   mtmas0 r3
   lis  r3, 0xC000
   ori r3, r3, 0x0500
   mtmas1	r3
   lis  r3, 0x0010
   ori r3, r3, 0x0000
   mtmas2	 r3
   lis  r3, 0x0010
   ori  r3, r3, 0x003F
   mtmas3	 r3
   tlbwe

#TLB2 =  PBRIDGE B - Usually handled by the BAM
   lis r3, 0x1002
   mtmas0 r3
   lis  r3, 0xC000
   ori   r3, r3, 0x0500
   mtmas1 r3
   lis  r3, 0xFFF0
   ori  r3, r3, 0x002A
   mtmas2 r3
   lis  r3, 0xFFF0
   ori  r3, r3, 0x003F
   mtmas3 r3
   tlbwe

#TLB3 = RAM - 1MB to cover all 596K 
   lis r3, 0x1003
   mtmas0 r3
   lis  r3, 0xC000
   ori  r3, r3, 0x0500
   mtmas1 r3
   lis  r3, 0x4000
   ori  r3, r3, 0x0000
   mtmas2 r3
   lis  r3, 0x4000
   ori  r3, r3, 0x003F
   mtmas3 r3
   tlbwe

#TLB4 = PBRIDGE A - Usually handled by the BAM
   lis r3, 0x1004
   mtmas0 r3
   lis  r3, 0xC000
   ori  r3, r3, 0x0800
   mtmas1 r3
   lis  r3, 0xC000
   ori  r3, r3, 0x000A
   mtmas2 r3
   lis  r3, 0xC000
   ori  r3, r3, 0x003F
   mtmas3 r3
   tlbwe

   blr
# End of cfg_MMU 


#************************************************************************/
# FUNCTION     : disable_SWT                                            */
# PURPOSE      : This function will disable the SWT.			*/
# INPUT NOTES  : None							*/
# RETURN NOTES : None                                                   */
# WARNING      : Registers used: R5,R6		                        */
#************************************************************************/

disable_SWT:
	lis r5,0xFFF3
	ori r5,r5,0x8000				# r5 = address of SWTCR 
	li r6, 0x0
	stw r6,0x0(r5)					# disable SWT 
	blr
# end of of disable_SWT
